function test_suite = testTril %#ok<*STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
p = polysym.empty;
assertTrue(isempty(p.tril))

function testDefault
p = polysym;
assertEqual(p.tril,p)

function testMultipleChars
p = polysym('xyz');
assertEqual(p.tril,p)

function testNoSecondTerm
M = randi(100,3);
p = polysym(M);
assertEqual(p.tril,polysym(tril(p)))

function testPositiveDiagonal
M = randi(100,5);
k = 2;
p = polysym(M);
assertEqual(tril(p,k),polysym(tril(p,k)))

function testNegativeDiagonal
M = randi(100,5);
k = -2;
p = polysym(M);
assertEqual(tril(p,k),polysym(tril(p,k)))